#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.FrmEnterPostTransfusionInfo;
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_PatientTransfusion : BaseTest 
	{

		private System.Guid _bloodUnitGuid;
		private System.Guid _patientGuid;
		private DataTable _dtPatientTransfusion;
		private BOL.PatientTransfusion _tstPT;
        

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
                new BOL.UnitTests.BOL_PatientTransfusionReaction().SaveImplicatedBloodUnits_Pass();

				this._dtPatientTransfusion = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PatientTransfusion WHERE ApplicationOfRecordId = 1 AND RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' ORDER BY LastUpdateDate DESC", true);

				this._bloodUnitGuid = (System.Guid)this._dtPatientTransfusion.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
				this._patientGuid = (System.Guid)this._dtPatientTransfusion.Rows[0][TABLES.Patient.PatientGuid];

				this.RefreshData = false;		
			}

			this._tstPT = new BOL.PatientTransfusion(this._patientGuid, this._bloodUnitGuid, false);
			this._tstPT.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.Default);
			VistALinkUnitTestHarness.RequireConnection();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection();
		}


		[Test]
		public void Ctor_Guid_Guid_Bool_Pass()
		{
			BOL.PatientTransfusion tmpPT = new BOL.PatientTransfusion(this._patientGuid, this._bloodUnitGuid, false);

			Assert.IsNotNull(tmpPT);
			Assert.IsTrue(tmpPT.BloodUnitGuid == this._bloodUnitGuid);
			Assert.IsTrue(tmpPT.PatientTransfusionGuid == (System.Guid)this._dtPatientTransfusion.Rows[0][TABLES.PatientTransfusion.PatientTransfusionGuid]);
			Assert.IsTrue(tmpPT.IsNew == false);
		}

		[Test]
		public void Ctor_Guid_Guid_Bool_Fail()
		{
			System.Guid unitGuid = this._bloodUnitGuid;

			BOL.PatientTransfusion tmpPT = new BOL.PatientTransfusion(System.Guid.NewGuid(), unitGuid, false);

			Assert.IsNotNull(tmpPT);
			Assert.IsTrue(tmpPT.BloodUnitGuid == unitGuid);
			Assert.IsTrue(tmpPT.IsNew);
		}

		
		[Test]
		public void Ctor_Guid_Pass()
		{
			BOL.PatientTransfusion tmpPT = new BOL.PatientTransfusion(this._bloodUnitGuid);

			Assert.IsNotNull(tmpPT);
			Assert.IsTrue(tmpPT.BloodUnitGuid == this._bloodUnitGuid);
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void Ctor_Guid_Fail()
		{
			System.Guid unitGuid = System.Guid.NewGuid();

			BOL.PatientTransfusion tmpPT = new BOL.PatientTransfusion(unitGuid);
		}
		
		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.PatientTransfusion tmpPT = new BOL.PatientTransfusion(this._dtPatientTransfusion.Rows[0]);

			Assert.IsNotNull(tmpPT);
			Assert.IsTrue(tmpPT.BloodUnitGuid == this._bloodUnitGuid);
			Assert.IsTrue(tmpPT.PatientTransfusionGuid == (System.Guid)this._dtPatientTransfusion.Rows[0][TABLES.PatientTransfusion.PatientTransfusionGuid]);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void Ctor_DataRow_Fail()
		{
			this.RefreshData = true;

			this._dtPatientTransfusion.Columns.Remove(TABLES.PatientTransfusion.RowVersion);

			BOL.PatientTransfusion tmpPT = new BOL.PatientTransfusion(this._dtPatientTransfusion.Rows[0]);
		}
		
		[Test]
		public void PatientTransfusionGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstPT.PatientTransfusionGuid = tstValue;

			Assert.IsTrue(this._tstPT.PatientTransfusionGuid == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientTransfusionGuid_Fail()
		{
		}

		[Test]
		public void AboIncompatibleComment_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPT.AboIncompatibleComment = tstValue;

			Assert.IsTrue(true);			//Set-Only property?? WHuuuuh??
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AboIncompatibleComment_Fail()
		{
		}


		[Test]
		public void Transfusionist1Id_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPT.Transfusionist1Id = tstValue;

			Assert.IsTrue(this._tstPT.Transfusionist1Id == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Transfusionist1Id_Fail()
		{
		}

		[Test]
		public void Transfusionist2Id_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPT.Transfusionist2Id = tstValue;

			Assert.IsTrue(this._tstPT.Transfusionist2Id == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Transfusionist2Id_Fail()
		{
		}

		[Test]
		public void TransfusionStartDateTime_Pass()
		{
			this._tstPT.TransfusionEndDateTime = System.DateTime.Now.AddYears(-1);
			this._tstPT.TransfusionStartDateTime = System.DateTime.Now.AddYears(-2);

			Assert.AreEqual(false, this._tstPT.IsRuleBroken(BROKEN.TransfusionStartDateTime3), "Broken.StartDate");
			Assert.AreEqual(false, this._tstPT.IsRuleBroken(BROKEN.TransfusionEndDateTime), "Broken.EndDate");
		}

		[Test]
		 
		public void TransfusionStartDateTime_Fail()
		{
			this._tstPT.TransfusionStartDateTime = System.DateTime.Now.AddYears(2);
			this._tstPT.TransfusionEndDateTime = System.DateTime.Now.AddYears(1);

			Assert.AreEqual(true, this._tstPT.IsRuleBroken(BROKEN.TransfusionEndDateTime), "Broken.StartDate");
			Assert.AreEqual(true, this._tstPT.IsRuleBroken(BROKEN.TransfusionEndDateTime2), "Broken.Future");
		}

		[Test]
		public void BedsideVerificationDate_Pass()
		{
			System.DateTime tstValue = this._tstPT.BedsideVerificationDate;

			Assert.IsTrue(this._tstPT.BedsideVerificationDate == tstValue);

		}

		[Test]
		 
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void BedsideVerificationDate_Fail()
		{
		}

		[Test]
		public void TransfusionEndDateTime_Pass()
		{
			//Set the end date in the past to avoid broken rules
			System.DateTime tstValue = System.DateTime.Now.AddYears(-1);

			this._tstPT.TransfusionStartDateTime = tstValue.AddYears(-1);
			this._tstPT.TransfusionEndDateTime = tstValue;

			Assert.IsTrue(this._tstPT.TransfusionEndDateTime == tstValue);
			Assert.AreEqual(false, this._tstPT.IsRuleBroken(BROKEN.TransfusionEndDateTime2), "Broken.Future");
		}

		[Test]
		 
		public void TransfusionEndDateTime_Fail()
		{
			//Set the end date in the future to break rules
			System.DateTime tstValue = System.DateTime.Now.AddDays(1);

			this._tstPT.TransfusionStartDateTime = tstValue.AddMonths(1);
			this._tstPT.TransfusionEndDateTime = tstValue;

			Assert.IsTrue(this._tstPT.TransfusionEndDateTime == tstValue);
			Assert.IsTrue(this._tstPT.IsRuleBroken(BROKEN.TransfusionEndDateTime));
			Assert.IsTrue(this._tstPT.IsRuleBroken(BROKEN.TransfusionEndDateTime2));
		}

		
		[Test]
		public void PatientLocation_Pass()
		{
			ArrayList locations = this._tstPT.GetLocations();

			string tstValue = locations[0].ToString();
			this._tstPT.PatientLocation = tstValue;

			Assert.IsTrue(this._tstPT.PatientLocation == tstValue);
			Assert.IsTrue(this._tstPT.IsRuleBroken(BROKEN.PatientLocation) == false);
		}

		[Test]
		public void PatientLocation_Fail()
		{
			this._tstPT.PatientLocation = string.Empty;
			Assert.IsTrue(this._tstPT.IsRuleBroken(BROKEN.PatientLocation));
		}

		
		[Test]
		public void TransfusionInterrupted_Pass()
		{
			bool tstValue = (!this._tstPT.TransfusionInterrupted);

			this._tstPT.TransfusionInterrupted = tstValue;

			Assert.IsTrue(this._tstPT.TransfusionInterrupted == tstValue);
			Assert.IsTrue(this._tstPT.IsRuleBroken(BROKEN.TransfusionInterrupted) == false);
		}

		[Test]
		public void TransfusionInterrupted_Fail()
		{
			Assert.IsTrue(this._tstPT.IsRuleBroken(BROKEN.TransfusionInterrupted));
		}

		
		[Test]
		public void TransfusedVolume_Pass()
		{
			int tstValue = new Random().Next(1, 999);

			this._tstPT.OriginalVolume = 1000;
			this._tstPT.TransfusedVolume = tstValue;

			Assert.AreEqual(tstValue, this._tstPT.TransfusedVolume, "value");
			Assert.AreEqual(false, this._tstPT.IsRuleBroken(BROKEN.TransfusedVolume), "broken rule");
		}

		[Test]
		public void TransfusedVolume_Fail()
		{
			this._tstPT.TransfusedVolume = int.MinValue;
			this._tstPT.TransfusionInterrupted = true;

			Assert.IsTrue(this._tstPT.IsRuleBroken(BROKEN.TransfusedVolume));
		}
		
		[Test]
		public void ReactionIndicator_Pass()
		{
			bool tstValue = (!this._tstPT.ReactionIndicator);
			
			this._tstPT.ReactionIndicator = tstValue;

			Assert.IsTrue(this._tstPT.ReactionIndicator == tstValue);
			Assert.IsTrue(this._tstPT.IsRuleBroken(BROKEN.ReactionIndicator) == false);
		}

		[Test]
		public void ReactionIndicator_Fail()
		{
			Assert.IsTrue(this._tstPT.IsRuleBroken(BROKEN.ReactionIndicator));
		}
		
		[Test]
		public void ReactionSymptoms_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();
			
			this._tstPT.ReactionSymptoms = tstValue;

			Assert.IsTrue(this._tstPT.ReactionSymptoms == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReactionSymptoms_Fail()
		{
		}

		[Test]
		public void PatientTransfusionComment_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();
			
			this._tstPT.PatientTransfusionComment = tstValue;

			Assert.IsTrue(this._tstPT.PatientTransfusionComment == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PatientTransfusionComment_Fail()
		{
		}

		[Test]
		public void OriginalVolume_Pass()
		{
			decimal tstValue = (decimal)new Random().Next(11111,99999);
			
			this._tstPT.OriginalVolume = tstValue;

			Assert.IsTrue(this._tstPT.OriginalVolume == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OriginalVolume_Fail()
		{
		}

		[Test]
		public void BloodUnitGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();
			
			this._tstPT.BloodUnitGuid = tstValue;

			Assert.IsTrue(this._tstPT.BloodUnitGuid == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodUnitGuid_Fail()
		{
		}

		[Test]
		public void GetLocations_Pass()
		{
			VistALinkUnitTestHarness.RequireConnection();
			
			try
			{
				ArrayList tstValue = this._tstPT.GetLocations();
				Assert.IsTrue(tstValue.Count > 0);
			}
			finally
			{
				VistALinkUnitTestHarness.ReleaseConnection();
			}

		}
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetLocations_Fail()
		{
			//New cache implementation causes this method to always pass
		}

		[Test]
		public void GetIssuedAndTransfusedUnitsForPatient_Pass()
		{
			//Adding code for coverage
			ArrayList dtArray = new ArrayList();
			ArrayList sprocArray = new ArrayList();

			Guid transfusedUnit1 = Guid.NewGuid();
			Guid transfusedUnit2 = Guid.NewGuid();
			Guid issuedUnit1 = Guid.NewGuid();

			Guid bpGuid = DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC).BloodProductGuid;
			Guid patientGuid = DataCreator.GetRandomRecordGuid(TABLES.Patient.TableName, "");

			DataCreator.CreateBloodUnit(transfusedUnit1, Guid.NewGuid(), patientGuid, bpGuid, false);
			DataCreator.CreateBloodUnit(transfusedUnit2, Guid.NewGuid(), patientGuid, bpGuid, false);
			DataCreator.CreateBloodUnit(issuedUnit1, Guid.NewGuid(), patientGuid, bpGuid, false);
			
			DataTable dtPT1 = SprocHelper.GetInsertPatientTransfusionSprocTable(Guid.NewGuid(), patientGuid, transfusedUnit1);
			DataTable dtPT2 = SprocHelper.GetInsertPatientTransfusionSprocTable(Guid.NewGuid(), patientGuid, transfusedUnit2);
			DataTable dtPT3 = SprocHelper.GetInsertPatientTransfusionSprocTable(Guid.NewGuid(), patientGuid, issuedUnit1);


			dtArray.Add(dtPT1);
			dtArray.Add(dtPT2);
			dtArray.Add(dtPT3);

			sprocArray.Add(SPROCS.InsertPatientTransfusion.StoredProcName);
			sprocArray.Add(SPROCS.InsertPatientTransfusion.StoredProcName);
			sprocArray.Add(SPROCS.InsertPatientTransfusion.StoredProcName);
			new Common.StoredProcedure().TransactionalGetValue(sprocArray, dtArray);

			UnitTestUtil.RunSQL("UPDATE PatientTransfusion SET TransfusionEndDateTime = null WHERE BloodUnitGuid = '" + transfusedUnit2.ToString() + "'");

			Guid poGuid = Guid.NewGuid();
			Guid ptGuid = Guid.NewGuid();
			Guid ocGuid = Guid.NewGuid();
			Guid ouGuid = Guid.NewGuid();
			Guid iuGuid = Guid.NewGuid();

			DataTable dtPT = SprocHelper.GetInsertPatientTreatmentSprocTable(ptGuid, patientGuid);
			DataTable dtPO = SprocHelper.GetInsertPatientOrderSprocTable(poGuid, ptGuid);
			DataTable dtOC = SprocHelper.GetHL7UpdateOrderedComponent(ocGuid, poGuid, true);
			DataTable dtOU = SprocHelper.GetInsertOrderedUnitSprocTable(ouGuid, ocGuid, issuedUnit1);
			DataTable dtIU = SprocHelper.GetInsertIssuedUnitSprocTable(iuGuid, issuedUnit1, patientGuid);

			dtArray = new ArrayList();
			sprocArray = new ArrayList();

			dtArray.Add(dtPT);
			dtArray.Add(dtPO);
			dtArray.Add(dtOC);
			dtArray.Add(dtOU);
			dtArray.Add(dtIU);

			sprocArray.Add(SPROCS.InsertPatientTreatment.StoredProcName);
			sprocArray.Add(SPROCS.InsertPatientOrder.StoredProcName);
			sprocArray.Add(SPROCS.HL7UpdateOrderedComponent.StoredProcName);
			sprocArray.Add(SPROCS.InsertOrderedUnit.StoredProcName);
			sprocArray.Add(SPROCS.InsertIssuedUnit.StoredProcName);

			new Common.StoredProcedure().TransactionalGetValue(sprocArray, dtArray);

			ArrayList tstValue = BOL.PatientTransfusion.GetIssuedAndTransfusedUnitsForPatient(patientGuid);
			
			Assert.IsTrue(tstValue.Count >= 0);
		}

		[Test]
		public void GetIssuedAndTransfusedUnitsForPatient_Fail()
		{
			ArrayList tstValue = BOL.PatientTransfusion.GetIssuedAndTransfusedUnitsForPatient(Guid.NewGuid());
			
			Assert.IsTrue(tstValue.Count == 0);
		}
		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetIssuedAndTransfusedUnitsForPatient_Fail_BadGuid()
		{
			BOL.PatientTransfusion.GetIssuedAndTransfusedUnitsForPatient(Guid.Empty);
		}

		[Test]
		public void GetTransfusionHistoryForPatientSpecimen_Pass()
		{
			ArrayList tstValue = BOL.PatientTransfusion.GetTransfusionHistoryForPatientSpecimen(System.Guid.NewGuid());
			
			Assert.IsNotNull(tstValue.Count >= 0);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetTransfusionHistoryForPatientSpecimen_Fail()
		{
			BOL.PatientTransfusion.GetTransfusionHistoryForPatientSpecimen(Guid.Empty);
		}

		[Test]
		public void Save_Pass()
		{
			try
			{
				VistALinkUnitTestHarness.RequireConnection();
				this.RefreshData = true;
				// **************************************************************************************************
				// TEST A. Existing PT, AboIncompatible = FALSE
				BOL.PatientTransfusion tstPT = new BOL.PatientTransfusion(_patientGuid, _bloodUnitGuid, false);
				tstPT.Transfusionist1Id = "Foo transfusionist 1";
				tstPT.Transfusionist1Id = "Foo transfusionist 2";

				tstPT.TransfusionStartDateTime = VBECSDateTime.GetDivisionCurrentDateTime().AddDays(-1);
				tstPT.TransfusionEndDateTime = VBECSDateTime.GetDivisionCurrentDateTime();
				tstPT.PatientLocation = tstPT.GetLocations()[0].ToString();
				tstPT.TransfusionInterrupted = true;
				tstPT.TransfusedVolume = 50;
				tstPT.ReactionIndicator = true;
				tstPT.ReactionSymptoms = "Foo symptoms";
				tstPT.Comments = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.ApplicationOfRecordId = 1;

				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
				bool tstValue = tstPT.Save(Common.WorkloadProcessID.TransfuseUnit);
			
				Assert.AreEqual(true, tstValue, "TestA");
				// **************************************************************************************************
				// TEST B. Existing PT, AboIncompatible = TRUE
				tstPT = new BOL.PatientTransfusion(_patientGuid, _bloodUnitGuid, true);
				tstPT.Transfusionist1Id = "Foo transfusionist 1";
				tstPT.Transfusionist1Id = "Foo transfusionist 2";

				tstPT.TransfusionStartDateTime = VBECSDateTime.GetDivisionCurrentDateTime().AddDays(-1);
				tstPT.TransfusionEndDateTime = VBECSDateTime.GetDivisionCurrentDateTime();
				tstPT.PatientLocation = tstPT.GetLocations()[0].ToString();
				tstPT.TransfusionInterrupted = true;
				tstPT.TransfusedVolume = 50;
				tstPT.ReactionIndicator = true;
				tstPT.ReactionSymptoms = "Foo symptoms";
				tstPT.Comments = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.AboIncompatibleComment = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.PatientTransfusionComment = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.ApplicationOfRecordId = 1;
			
				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
				tstValue = tstPT.Save(Common.WorkloadProcessID.TransfuseUnit);
			
				Assert.AreEqual(true, tstValue, "TestB");
				// **************************************************************************************************
				// TEST C.  New PT, AboIncompatible = FALSE
				Guid [] PatientAndUnitGuids = CreateIssuedUnit();
				Guid patientGuid = PatientAndUnitGuids[0];
				Guid unitGuid = PatientAndUnitGuids[1];
				
				tstPT = new BOL.PatientTransfusion( patientGuid, unitGuid, false );
				tstPT.Transfusionist1Id = "Foo transfusionist 1";
				tstPT.Transfusionist1Id = "Foo transfusionist 2";

				tstPT.TransfusionStartDateTime = VBECSDateTime.GetDivisionCurrentDateTime().AddDays(-1);
				tstPT.TransfusionEndDateTime = VBECSDateTime.GetDivisionCurrentDateTime();
				tstPT.PatientLocation = tstPT.GetLocations()[0].ToString();
				tstPT.TransfusionInterrupted = true;
				tstPT.TransfusedVolume = 50;
				tstPT.ReactionIndicator = true;
				tstPT.ReactionSymptoms = "Foo symptoms";
				tstPT.Comments = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.PatientTransfusionComment = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.ApplicationOfRecordId = 1;

				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
				tstValue = tstPT.Save(Common.WorkloadProcessID.TransfuseUnit);
			
				Assert.AreEqual(true, tstValue, "TestC");
				// **************************************************************************************************
				// TEST D.  New PT, AboIncompatible = TRUE
				PatientAndUnitGuids = CreateIssuedUnit();
				patientGuid = PatientAndUnitGuids[0];
				unitGuid = PatientAndUnitGuids[1];

				tstPT = new BOL.PatientTransfusion(patientGuid, unitGuid, true);
				tstPT.Transfusionist1Id = "Foo transfusionist 1";
				tstPT.Transfusionist1Id = "Foo transfusionist 2";

				tstPT.TransfusionStartDateTime = VBECSDateTime.GetDivisionCurrentDateTime().AddDays(-1);
				tstPT.TransfusionEndDateTime = VBECSDateTime.GetDivisionCurrentDateTime();
				tstPT.PatientLocation = tstPT.GetLocations()[0].ToString();
				tstPT.TransfusionInterrupted = true;
				tstPT.TransfusedVolume = 50;
				tstPT.ReactionIndicator = true;
				tstPT.ReactionSymptoms = "Foo symptoms";
				tstPT.Comments = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.AboIncompatibleComment = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.PatientTransfusionComment = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.ApplicationOfRecordId = 1;

				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
				tstValue = tstPT.Save(Common.WorkloadProcessID.TransfuseUnit);
			
				Assert.AreEqual(true, tstValue, "TestD");
				// **************************************************************************************************
				// TEST E Existing PT, AboIncompatible = FALSE
				tstPT = new BOL.PatientTransfusion(_patientGuid, _bloodUnitGuid, false);

				tstPT.Transfusionist1Id = "Foo transfusionist 1";
				tstPT.Transfusionist1Id = "Foo transfusionist 2";

				tstPT.TransfusionStartDateTime = VBECSDateTime.GetDivisionCurrentDateTime().AddDays(-1);
				tstPT.TransfusionEndDateTime = VBECSDateTime.GetDivisionCurrentDateTime();
				tstPT.PatientLocation = tstPT.GetLocations()[0].ToString();
				tstPT.TransfusionInterrupted = true;
				tstPT.TransfusedVolume = 50;
				tstPT.ReactionIndicator = true;
				tstPT.ReactionSymptoms = "Foo symptoms";
				tstPT.Comments = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.PatientTransfusionComment = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.ApplicationOfRecordId = 1;

				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
				tstValue = tstPT.Save(Common.WorkloadProcessID.TransfuseUnit);
			
				Assert.AreEqual(true, tstValue, "TestE");
				// **************************************************************************************************
				// TEST F Existing PT, AboIncompatible = FALSE, No comments
				UnitTestUtil.RunSQL("DELETE FROM PatientTransfusionComment WHERE PatientTransfusionGuid = '" + tstPT.PatientTransfusionGuid + "'");
				
				tstPT = new BOL.PatientTransfusion(_patientGuid, _bloodUnitGuid, false);

				tstPT.Transfusionist1Id = "Foo transfusionist 1";
				tstPT.Transfusionist1Id = "Foo transfusionist 2";

				tstPT.TransfusionStartDateTime = VBECSDateTime.GetDivisionCurrentDateTime().AddDays(-1);
				tstPT.TransfusionEndDateTime = VBECSDateTime.GetDivisionCurrentDateTime();
				tstPT.PatientLocation = tstPT.GetLocations()[0].ToString();
				tstPT.TransfusionInterrupted = true;
				tstPT.TransfusedVolume = 50;
				tstPT.ReactionIndicator = true;
				tstPT.ReactionSymptoms = "Foo symptoms";
				tstPT.Comments = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.PatientTransfusionComment = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.ApplicationOfRecordId = 1;

				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
				tstValue = tstPT.Save(Common.WorkloadProcessID.TransfuseUnit);
			
				Assert.AreEqual(true, tstValue, "CleanupF");
				// **************************************************************************************************
				// TEST G Existing PT, AboIncompatible = TRUE, No comments
				UnitTestUtil.RunSQL("DELETE FROM PatientTransfusionComment WHERE PatientTransfusionGuid = '" + tstPT.PatientTransfusionGuid + "'");
				
				tstPT = new BOL.PatientTransfusion(_patientGuid, _bloodUnitGuid, true);

				tstPT.Transfusionist1Id = "Foo transfusionist 1";
				tstPT.Transfusionist1Id = "Foo transfusionist 2";

				tstPT.TransfusionStartDateTime = VBECSDateTime.GetDivisionCurrentDateTime().AddDays(-1);
				tstPT.TransfusionEndDateTime = VBECSDateTime.GetDivisionCurrentDateTime();
				tstPT.PatientLocation = tstPT.GetLocations()[0].ToString();
				tstPT.TransfusionInterrupted = true;
				tstPT.TransfusedVolume = 50;
				tstPT.ReactionIndicator = true;
				tstPT.ReactionSymptoms = "Foo symptoms";
				tstPT.AboIncompatibleComment = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.Comments = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.PatientTransfusionComment = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.ApplicationOfRecordId = 1;

				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
				tstValue = tstPT.Save(Common.WorkloadProcessID.TransfuseUnit);
			
				Assert.AreEqual(true, tstValue, "CleanupG");
				// **************************************************************************************************
				// TEST H Existing PT, AboIncompatible = FALSE, No comments, ApplicationOfRecordType = BCE_COTS
				UnitTestUtil.RunSQL("DELETE FROM PatientTransfusionComment WHERE PatientTransfusionGuid = '" + tstPT.PatientTransfusionGuid + "'");
				
				tstPT = new BOL.PatientTransfusion(_patientGuid, _bloodUnitGuid, false);

				tstPT.Transfusionist1Id = "Foo transfusionist 1";
				tstPT.Transfusionist1Id = "Foo transfusionist 2";

				tstPT.TransfusionStartDateTime = VBECSDateTime.GetDivisionCurrentDateTime().AddDays(-1);
				tstPT.TransfusionEndDateTime = VBECSDateTime.GetDivisionCurrentDateTime();
				tstPT.PatientLocation = tstPT.GetLocations()[0].ToString();
				tstPT.TransfusionInterrupted = true;
				tstPT.TransfusedVolume = 50;
				tstPT.ReactionIndicator = true;
				tstPT.ReactionSymptoms = "Foo symptoms";
				tstPT.Comments = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.PatientTransfusionComment = string.Concat("Foo comments ", DateTime.UtcNow.ToLongTimeString());
				tstPT.ApplicationOfRecordId = Common.Utility.GetApplicationOfRecordTypeIntegerValue(Common.ApplicationOfRecordType.BCE_COTS);

				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
				tstValue = tstPT.Save(Common.WorkloadProcessID.TransfuseUnit);
			
				Assert.AreEqual(true, tstValue, "CleanupH");
			}
			finally
			{
				VistALinkUnitTestHarness.ReleaseConnection();
			}
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void Save_Fail()
		{
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
			this._tstPT.Save(Common.WorkloadProcessID.TransfuseUnit);
		}

		[Test]
		public void GetRecentlyIssuedAndTransfusedUnitsForPatient_Pass()
		{
			ArrayList tstValue = BOL.PatientTransfusion.GetRecentlyIssuedAndTransfusedUnitsForPatient(this._patientGuid);
			Assert.IsTrue(tstValue.Count >= 0);
		}

		[Test]
		public void GetRecentlyIssuedAndTransfusedUnitsForPatient_Fail()
		{
			ArrayList tstValue = BOL.PatientTransfusion.GetRecentlyIssuedAndTransfusedUnitsForPatient(System.Guid.NewGuid());
			Assert.IsTrue(tstValue.Count == 0);
		}

		[Test]
		public void GetRecentlyIssuedAndTransfusedUnitsForPatientCount_Pass()
		{
			Assert.IsTrue(BOL.PatientTransfusion.GetRecentlyIssuedAndTransfusedUnitsForPatientCount(this._patientGuid) >= 0);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetRecentlyIssuedAndTransfusedUnitsForPatientCount_Fail()
		{
			Assert.IsTrue(BOL.PatientTransfusion.GetRecentlyIssuedAndTransfusedUnitsForPatientCount(Guid.Empty)==0);
		}

		[Test]
		public void GetTransfusedUnitsForPatient_Pass()
		{
			ArrayList tstValue = BOL.PatientTransfusion.GetTransfusedUnitsForPatient(this._patientGuid);
			Assert.IsTrue(tstValue == null || tstValue.Count > 0);
		}

		[Test]
		public void GetTransfusedUnitsForPatient_Fail()
		{
			ArrayList tstValue = BOL.PatientTransfusion.GetTransfusedUnitsForPatient(System.Guid.NewGuid());
			Assert.IsNull(tstValue);
		}

		[Test]
		public void GetPatientTransfusionRecords_Pass()
		{
			ArrayList tstValue = BOL.PatientTransfusion.GetPatientTransfusionRecords(this._patientGuid);
			Assert.IsTrue(tstValue == null || tstValue.Count > 0);
		}

		[Test]
		public void GetPatientTransfusionRecords_Fail()
		{
			ArrayList tstValue = BOL.PatientTransfusion.GetPatientTransfusionRecords(System.Guid.NewGuid());
			Assert.IsNull(tstValue);
		}

		[Test]
		public void IsTransfusionHistoryforPatient_Pass()
		{
			bool tstValue = BOL.PatientTransfusion.IsTransfusionHistoryforPatient(this._patientGuid);
			Assert.IsTrue(true);
		}

		[Test]
		public void IsTransfusionHistoryforPatient_Fail()
		{
			bool tstValue = BOL.PatientTransfusion.IsTransfusionHistoryforPatient(System.Guid.NewGuid());
			Assert.IsTrue(tstValue == false);
		}

		[Test]
		public void GetLastTransfusionDateTime_Pass()
		{
			System.DateTime tstValue = BOL.PatientTransfusion.GetLastTransfusionDateTime(this._patientGuid, System.DateTime.Now.AddYears(-1), System.DateTime.Now);
			Assert.IsTrue(true);
		}

		[Test]
		public void GetLastTransfusionDateTime_Fail()
		{
			System.DateTime tstValue = BOL.PatientTransfusion.GetLastTransfusionDateTime(System.Guid.NewGuid(), System.DateTime.Now.AddYears(-1), System.DateTime.Now);
			Assert.IsTrue(tstValue == DateTime.MinValue);
		}

		[Test]
		public void GetTransfusedPatient_Pass()
		{
			BOL.Patient tstValue = BOL.PatientTransfusion.GetTransfusedPatient(this._bloodUnitGuid);
			Assert.IsTrue(tstValue.PatientGuid == this._patientGuid);
		}

		[Test]
		public void GetTransfusedPatient_Fail()
		{
			BOL.Patient tstValue = BOL.PatientTransfusion.GetTransfusedPatient(System.Guid.NewGuid());
			Assert.IsTrue(tstValue.IsNew == true);
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow drIn = this._dtPatientTransfusion.NewRow();

			DataRow drOut = this._tstPT.LoadDataRowFromThis(drIn);

			Assert.IsTrue(drIn == drOut);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}


		[Test]
		public void GetTransfusedUnitsInDateRangeCount_Pass()
		{
			System.DateTime startDate = System.DateTime.Now.AddYears(-1);
			System.DateTime endDate = System.DateTime.Now.AddYears(1);

			int tstValue = BOL.PatientTransfusion.GetTransfusedUnitsInDateRangeCount(startDate, endDate);

			Assert.IsTrue(tstValue >= 0);
		}

		[Test]
		public void GetTransfusedUnitsInDateRangeCount_Fail()
		{
			System.DateTime startDate = System.DateTime.Now.AddYears(-1);
			System.DateTime endDate = System.DateTime.Now.AddYears(1);

			int tstValue = BOL.PatientTransfusion.GetTransfusedUnitsInDateRangeCount(endDate, startDate);

			Assert.IsTrue(tstValue == 0);
		}

		[Test]
		public void GetTransfusedUnitsInDateRangeCount_Guid_Pass()
		{
			System.DateTime startDate = System.DateTime.Now.AddYears(-1);
			System.DateTime endDate = System.DateTime.Now.AddYears(1);
			
			int tstValue = BOL.PatientTransfusion.GetTransfusedUnitsInDateRangeCount(startDate, endDate, this._patientGuid);

			Assert.IsTrue(tstValue >= 0);
		}

		[Test]
		public void GetTransfusedUnitsInDateRangeCount_Guid_Fail()
		{
			System.DateTime startDate = System.DateTime.Now.AddYears(-1);
			System.DateTime endDate = System.DateTime.Now.AddYears(1);

			int tstValue = BOL.PatientTransfusion.GetTransfusedUnitsInDateRangeCount(endDate, startDate, this._patientGuid);

			Assert.IsTrue(tstValue == 0);
		}

		[Test]
		public void GetTransfusedUnitsInDateRange_Pass()
		{
			System.DateTime startDate = System.DateTime.Now.AddYears(-1);
			System.DateTime endDate = System.DateTime.Now.AddYears(1);
			
			DataTable tstValue = BOL.PatientTransfusion.GetTransfusedUnitsInDateRange(startDate, endDate);

			Assert.IsTrue(tstValue.Rows.Count >= 0);
		}

		[Test]
		public void GetTransfusedUnitsInDateRange_Fail()
		{
			System.DateTime startDate = System.DateTime.Now.AddYears(-1);
			System.DateTime endDate = System.DateTime.Now.AddYears(1);

			DataTable tstValue = BOL.PatientTransfusion.GetTransfusedUnitsInDateRange(endDate, startDate);

			Assert.IsTrue(tstValue.Rows.Count == 0);
		}

		
		[Test]
		public void GetTransfusedUnitsInDateRange_Guid_Pass()
		{
			System.DateTime startDate = System.DateTime.Now.AddYears(-1);
			System.DateTime endDate = System.DateTime.Now.AddYears(1);
			
			DataTable tstValue = BOL.PatientTransfusion.GetTransfusedUnitsInDateRange(startDate, endDate, this._patientGuid);

			Assert.IsTrue(tstValue.Rows.Count >= 0);
		}

		[Test]
		public void GetTransfusedUnitsInDateRange_Guid_Fail()
		{
			System.DateTime startDate = System.DateTime.Now.AddYears(-1);
			System.DateTime endDate = System.DateTime.Now.AddYears(1);

			DataTable tstValue = BOL.PatientTransfusion.GetTransfusedUnitsInDateRange(endDate, startDate, this._patientGuid);

			Assert.IsTrue(tstValue.Rows.Count == 0);
		}

		#region unit test helper methods

		/// <summary>
		/// Delete a Patient Transfusion record.  This needs to be done so the saving of a new one can 
		/// be tested.
		/// </summary>
		/// <returns></returns>
		private void DeletePatientTransfusion(System.Guid ptGuid)
		{
			string query = "DELETE FROM PatientTransfusion WHERE PatientTransfusionGuid = '" + ptGuid + "'";
			string query2 = "UPDATE BloodUnitStatus SET UnitStatusCode = 'I' WHERE BLoodUnitGuid = '" + this._bloodUnitGuid + "'";

			int uCheck = UnitTestUtil.RunSQL(query);
			uCheck = UnitTestUtil.RunSQL(query2);
		}

		/// <summary>
		///  To test the update methods, we must make sure there is a Patient Transfusion record saved. 
		/// </summary>
		private bool InsertPatientTransfusion()
		{
			this._tstPT.Transfusionist1Id = "Foo transfusionist 1";
			this._tstPT.Transfusionist1Id = "Foo transfusionist 2";
		
			this._tstPT.TransfusionStartDateTime = DateTime.Now;
			this._tstPT.TransfusionEndDateTime = DateTime.Now.AddMinutes(10);
			this._tstPT.PatientLocation = this._tstPT.GetLocations()[0].ToString();
			this._tstPT.TransfusionInterrupted = true;
			this._tstPT.TransfusedVolume = 50;
			this._tstPT.ReactionIndicator = true;
			this._tstPT.ReactionSymptoms = "Foo symptoms";
			this._tstPT.Comments = "Foo comments";
			
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfuseUnit);
			return this._tstPT.Save(Common.WorkloadProcessID.TransfuseUnit);
		}

		/// <summary>
		/// CreateIssuedUnit
		/// </summary>
		/// <returns>Guid [] </returns>
		private Guid [] CreateIssuedUnit()
		{
			bool createOrderStatus = true;
			//
			Guid [] returnGuids = new Guid[2];
			//
			Guid patientGuid = Guid.NewGuid();
			int retValue = new Common.StoredProcedure().TransactionalGetValue( SPROCS.InsertPatient.StoredProcName, SprocHelper.GetInsertPatientSprocTable(patientGuid) );
			//
			System.Guid ptGuid = Guid.NewGuid();
			retValue = new Common.StoredProcedure().TransactionalGetValue( SPROCS.InsertPatientTreatment.StoredProcName, SprocHelper.GetInsertPatientTreatmentSprocTable(ptGuid, patientGuid) );
			//TODO: this method is a copy from datacreator - there can be only 1
            DataTable dtCheck = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 BloodProductGuid FROM ProductShipper WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");
            if (dtCheck.Rows.Count == 0) DataCreator.CreateBloodUnit(true);	//lazy but fast
            Guid bpGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodProductGuid FROM ProductShipper WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");
            System.Guid busGuid = System.Guid.NewGuid();
			System.Guid buGuid = System.Guid.NewGuid();
			System.Guid iuGuid = System.Guid.NewGuid();
			System.Guid ouGuid = System.Guid.NewGuid();
			System.Guid ocGuid = System.Guid.NewGuid();
			System.Guid poGuid = System.Guid.NewGuid();
			System.Guid psGuid = System.Guid.NewGuid();
			System.Guid otGuid = System.Guid.NewGuid();
			string specimenUid = DataCreator.GetNewSpecimenUid();

			//Create a unit to Issue  --- Was manullay setting UnitStatusCode to I here... UGH!
			DataCreator.CreateBloodUnit(buGuid, busGuid, System.Guid.Empty, bpGuid, true);

			//Hopefully that worked...
			//Not sure if I need a PatientSpecimen or not, so holding off here....
			System.Collections.ArrayList dtArray = new System.Collections.ArrayList();
			System.Collections.ArrayList spArray = new System.Collections.ArrayList();

			dtArray.Add(SprocHelper.GetInsertPatientSpecimenSprocTable(psGuid, patientGuid, specimenUid));
			spArray.Add(SPROCS.InsertPatientSpecimen.StoredProcName);

			dtArray.Add(SprocHelper.GetInsertPatientOrderSprocTable(poGuid, ptGuid));
			spArray.Add(SPROCS.InsertPatientOrder.StoredProcName);

			dtArray.Add(SprocHelper.GetHL7UpdateOrderedComponent(ocGuid, poGuid, createOrderStatus));
			spArray.Add(SPROCS.HL7UpdateOrderedComponent.StoredProcName);

			dtArray.Add(SprocHelper.GetInsertOrderedUnitSprocTable(ouGuid, ocGuid, buGuid));
			spArray.Add(SPROCS.InsertOrderedUnit.StoredProcName);

			dtArray.Add(SprocHelper.GetInsertIssuedUnitSprocTable(iuGuid, buGuid, patientGuid));
			spArray.Add(SPROCS.InsertIssuedUnit.StoredProcName);

			dtArray.Add(SprocHelper.GetInsertOrderedTestSprocTable(otGuid, poGuid, psGuid));
			spArray.Add(SPROCS.InsertOrderedTest.StoredProcName);

			retValue = new Common.StoredProcedure().TransactionalGetValue(spArray, dtArray);

			if (retValue != 0)
			{
				throw new BOL.BusinessObjectException("CRAP! THE ISSUE UNIT CREATION FAILED!!!");
			}
			else
			{
				if (createOrderStatus)
				{
					UnitTestUtil.RunSQL("UPDATE OrderedComponent SET TaskStatusCode = 'I' WHERE OrderedComponentGuid = '" + ocGuid.ToString() + "'");
				}
			}
			
			
			
			
			//			Guid bloodUnitGuid = Guid.NewGuid();
			//			DataCreator.CreateBloodUnit( bloodUnitGuid, Guid.NewGuid(), patientGuid, bpGuid, true );
			//			Guid iuGuid = Guid.NewGuid();
			//			Guid ptGuid = Guid.NewGuid();
			//			Guid poGuid = Guid.NewGuid();
			//			Guid psGuid = Guid.NewGuid();
			//			Guid ocGuid = Guid.NewGuid();
			//			Guid otGuid = Guid.NewGuid();
			//			Guid ouGuid = Guid.NewGuid();
			//
			//			System.Collections.ArrayList dtArray = new ArrayList();
			//			System.Collections.ArrayList sprocArray = new ArrayList();
			//
			//			dtArray.Add( SprocHelper.GetInsertPatientTreatmentSprocTable(ptGuid, patientGuid) );
			//			sprocArray.Add(SPROCS.InsertPatientTreatment.StoredProcName);
			//
			//			dtArray.Add( SprocHelper.GetInsertPatientOrderSprocTable(poGuid, ptGuid) );
			//			sprocArray.Add(SPROCS.InsertPatientOrder.StoredProcName);
			//
			//			dtArray.Add( SprocHelper.GetHL7UpdateOrderedComponent(ocGuid, poGuid, false) );
			//			sprocArray.Add(SPROCS.HL7UpdateOrderedComponent.StoredProcName);
			//
			//			dtArray.Add( SprocHelper.GetInsertOrderedUnitSprocTable(ouGuid, ocGuid, bloodUnitGuid) );
			//			sprocArray.Add(SPROCS.InsertOrderedUnit.StoredProcName);
			//
			//			dtArray.Add(SprocHelper.GetInsertIssuedUnitSprocTable(iuGuid, bloodUnitGuid, patientGuid));
			//			sprocArray.Add(SPROCS.InsertIssuedUnit.StoredProcName);
			//
			//			retValue = new Common.StoredProcedure().TransactionalGetValue(sprocArray, dtArray);
			//
			//			Assertion.AreEqual("BOL.PatientTransfusion.Save(" + bloodUnitGuid.ToString() + ")", 0, retValue);

			//
			returnGuids[0] = patientGuid;
			returnGuids[1] = buGuid;
			//
			return returnGuids;
			
		}

		#endregion
	}
}
#endif


